terraform {
  required_version = ">= 1.0.0, < 2.0.0"

  required_providers {
    aws = {
      source  = "hashicorp/aws"
      version = "~> 4.0"
    }
  }

  backend "s3" {
    # Ten plik konfiguracyjny w trakcie testu będzie wypełniony automatycznie
    # przez Terratest. Jeżeli chcesz ten przykład wykonać ręcznie, usuń znaki
    # komentarza na początku poniższych wierszy i uzupełnij je żądanymi danymi.

    # bucket         = "<NAZWA KUBEŁKA S3>"
    # key            = "<ŚCIEŻKA DOSTĘPU>/terraform.tfstate"
    # region         = "us-east-2"
    # dynamodb_table = "<NAZWA TABELI DYNAMODB>"
    # encrypt        = true
  }
}

provider "aws" {
  region = "us-east-2"
  alias  = "primary"
}

provider "aws" {
  region = "us-west-1"
  alias  = "replica"
}

module "mysql_primary" {
  source = "../../../../modules/data-stores/mysql"

  providers = {
    aws = aws.primary
  }

  db_name     = var.db_name

  db_username = var.db_username
  db_password = var.db_password

  # Ta zmienna jest konieczna do zapewnienia obsługi replikacji.
  backup_retention_period = 1
}

module "mysql_replica" {
  source = "../../../../modules/data-stores/mysql"

  providers = {
    aws = aws.replica
  }

  # Utworzenie repliki podstawowej bazy danych.
  replicate_source_db = module.mysql_primary.arn
}
